#!/bin/bash

#インストール先フォルダ設定
#-------------------------------------
DEST_DIR=/opt/OMRON
#-------------------------------------
SERVICE_NAME="PowerAttendantBasicEdition"
INSTALL_DIR=PowerAttendantBasic
EXEC_DIR_PATH=$DEST_DIR/$INSTALL_DIR
FILENAME="PowerAttendantBasicEdition"
EXEC_PAHT="$EXEC_DIR_PATH/$FILENAME"
LICENSE_FILENAME_JP="PAB_LicenseAgreement_jp.txt"
LICENSE_FILENAME_EN="PAB_LicenseAgreement_en.txt"
LINK_DIR=$(dirname "$(readlink -f "$0")")
SOURCE_DIR=$LINK_DIR/$INSTALL_DIR

if [ "$(id -u)" -ne 0 ]; then
    echo "You are not running as root. Exiting script."
    exit 1
else
    :
fi

echo "Japanese or English?(J/E): "
read input_lang

case $input_lang in
    E|e)

        ;;
    J|j)

        ;;
    *)
        exit 1
        ;;
esac


echo


if [[ $input_lang == "E" || $input_lang == "e" ]]; then
    echo "Show the software license agreement."
    echo
    read -p "Press Enter:"
    echo "------------------------"
    cat "./$INSTALL_DIR/$LICENSE_FILENAME_EN"
    echo "------------------------"
    read -p "Do you agree this license? (Y/N): " yn_check

elif [[ $input_lang == "J" || $input_lang == "j" ]]; then
    echo "ソフトウェア使用許諾契約書を表示します。"
    echo
    read -p "Enterキーを押してください: "
    echo "------------------------"
    cat "./$INSTALL_DIR/$LICENSE_FILENAME_JP"
    echo "------------------------"
    read -p "ソフトウェア使用許諾に同意しますか？(Y/N): " yn_check
fi


if [[ "$yn_check" != "Y" && "$yn_check" != "y" ]]; then
    exit 1
fi

mkdir -p $DEST_DIR
mkdir -p $DEST_DIR/$INSTALL_DIR


systemctl stop $SERVICE_NAME > /dev/null 2>&1
cp -r -f "$SOURCE_DIR" "$DEST_DIR"

if [[ $input_lang == "E" || $input_lang == "e" ]]; then
    $EXEC_PAHT SET 1002 en

elif [[ $input_lang == "J" || $input_lang == "j" ]]; then
    $EXEC_PAHT SET 1002 jp
fi

# サービスファイルの内容を変数に格納
SERVICE_FILE_CONTENT="[Unit]
Description=$SERVICE_NAME
Name=PowerAttendantBasicd

[Service]
ExecStart=$EXEC_PAHT start
Restart=always
RestartSec=5
Type=simple
User=root
Group=root

[Install]
WantedBy=multi-user.target"

# サービスファイルを作成
echo "$SERVICE_FILE_CONTENT" | tee /etc/systemd/system/$SERVICE_NAME.service

# サービスを有効化して起動
systemctl daemon-reload
systemctl enable $SERVICE_NAME
systemctl start $SERVICE_NAME

sleep 5

chmod 777 $EXEC_DIR_PATH/Setting.ini

rm -rf "$SOURCE_DIR"

echo 
if [[ $input_lang == "E" || $input_lang == "e" ]]; then
    echo "Installed in "$DEST_DIR/$INSTALL_DIR/"."

elif [[ $input_lang == "J" || $input_lang == "j" ]]; then
    echo $DEST_DIR/$INSTALL_DIR/"にインストール完了しました"
fi

